' PicoPong for PicoMite 2350 HDMI/VGA  v0.24 magic
' by twofingers/6-2025
' ----------------------------------------------------
'Option AUDIO GP10, GP11
Option default float
Option explicit
Option KEYBOARD repeat 400,100 'default for USB-KB: 600,150


MODE 3'or 2' User config
Map reset
Sub selectBall'select your 'ball':  User config
 'Restore witch     '48x48
 'Restore globe     '48x48
 'Restore bear      '24x32
 'Restore rabbit    '48x43
 'Restore rabbit2   '48x48
 'Restore strawberry'48x43
 'Restore prop      '48x48
 'Restore peterp    '30x64
 'Restore karateka  '64x64
' Restore elephant  '64x64
  Restore dots      '48x48
End Sub

Const TRUE=1, FALSE= TRUE = 0
Const DEBUG        = FALSE
Const FW=MM.Info(FONTWIDTH), FH=MM.Info(FONTHEIGHT)
Const HRES         = MM.HRES '480
Const VRES         = MM.VRES '640
Const HQ           = HRES/640
Const VQ           = VRES/480

Const PD_SPEED     = 12*HQ
Const PD_WIDTH     = 10*VQ
Dim integer PD_HEIGHT = 60*HQ
Dim integer bh%, bw%  'BALL HEIGHT,WIDTH from DATAs
Dim integer VOLUME = 13

'--- read 'ball' HEADER (Format: "height,num,width")
Dim String hdStr$
selectBall()
Read hdStr$
Const BALL_HEIGHT  = Val(Left$(hdStr$,Instr(hdStr$, ",")-1))
Const BALL_WIDTH   = Val(Mid$(hdStr$,Instr(Instr(hdStr$, ",")+1,hdStr$,",")+1))
Dim   BALL_SPEED   = 7*HQ'(4-15)' User config
Dim   SPEED_REST   = BALL_SPEED
Const SPEED_LIMIT  = BALL_SPEED
Const maxPOINTS    = 51 'gameover, User config

Const C_BG         = RGB(black)
Const BC           = RGB(black)
Const C_PD_L       = RGB(red)
Const C_PD_R       = RGB(cyan)
Const C_BALL       = RGB(magenta)
Const C_TEXT       = RGB(yellow)
Const C_LINE       = RGB(white)
Const FC           = RGB(white)
Dim integer cm(15)=(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)'color map
Colour Map cm(),cm()

Dim String k$,cUp$=Chr$(128),cDn$=Chr$(129),Esc$=Chr$(27),F1$=Chr$(145)

Dim float leftY    = VRES /2 -PD_HEIGHT/2
Dim float rightY   = VRES /2 -PD_HEIGHT/2
Dim float ballX    = HRES /2 -BALL_HEIGHT/2
Dim float ballY    = BALL_HEIGHT + (VRES - BALL_HEIGHT*2) * Rnd
Dim float ballDX   = BALL_SPEED
Dim float ballDY   = BALL_SPEED
Dim integer i,soundOn%=1'FALSE

Dim scoreL% = 0
Dim scoreR% = 0
Dim pdDataL%(PD_WIDTH * PD_HEIGHT -1)
Dim pdDataR%(PD_WIDTH * PD_HEIGHT -1)
Dim ballData%(BALL_WIDTH*BALL_HEIGHT-1)
Dim altballData%(BALL_WIDTH*BALL_HEIGHT-1)
Dim hMask%(PD_WIDTH -1)
Dim integer dir=0
Dim integer s_activ=3

'sound effects
Const SAMPLES        = 4096
Const PACKED_SIZE    = SAMPLES \ 4

Dim raw%(SAMPLES -1),sound
Dim packed%(PACKED_SIZE -1)
Dim temp%(PACKED_SIZE -1)
Dim pout%(PACKED_SIZE -1)

Restore pong
For i = 0 To 1007
  Read sound
  If i<1024 Then raw%(i)=sound Else raw%(i)=2047
Next
For i = i To Bound(raw%())
  raw%(i)=2047
Next
Memory pack raw%(),packed%(),4096,16
Math SCALE packed%(),1,temp%()'save
Play LOAD SOUND packed%()

Restore oing'lout
For i = 0 To 220
  Read sound
  pout%(i)=sound
Next

remapCol()
selectBall()
loadSprites()
drawField()

Sprite SHOW #1, 0,leftY,2
Sprite SHOW #2, HRES -PD_WIDTH, rightY,2,1
Sprite SHOW #3,Int(ballX), ballY, 1,Choice(dir>0,1,0)

SetTick 11, BallMove  'takes<1ms
SetTick 29, Opponent,2'takes<1ms, User config: 20-80
k$ = " "
s_activ=3
Text HRES/2,80, "PicoPongo", "CT", 3, 2*VQ, C_TEXT

Do
  Select Case k$
  Case " "
    SetTick pause, BallMove
    SetTick pause, Opponent,2
    Text HRES /2, 35*FH*HQ, "Press any key", "CT",3 ,1, RGB(cerulean)
    Do :Loop While Inkey$=""
    SetTick resume, BallMove
    SetTick resume, Opponent,2
    drawField(): k$ = cUp$
  Case F1$
    showHelp()
  Case "t"
    soundOn%=(soundOn%=FALSE)
  Case "." To "9"
    VOLUME=Val(k$)*25/9
  Case "s"
    Save image "b:PrScr"
  Case Esc$
    gameOver()
  End Select
  getCursor()
Loop '*********** Main loop (s. Settick) ************


Sub getCursor
  k$=Chr$(KeyDown(1))
  If k$ = cUp$ Then
    leftY = Max(0,leftY -PD_SPEED)
    Box 0, leftY-PD_WIDTH/2,PD_WIDTH, leftY+PD_WIDTH/2, 0,,C_BG
    Sprite SHOW #1, 0, leftY, 2
  ElseIf k$ = cDn$ Then
    leftY = Min(VRES -PD_HEIGHT,leftY +PD_SPEED)
    Box 0, leftY-PD_WIDTH/2,PD_WIDTH, leftY+PD_WIDTH/2, 0,,C_BG
    Sprite SHOW #1, 0, leftY, 2
/*
  'opponent
  ElseIf k$ = Chr$(131) Then ' add mouse control
    rightY =Max(0, rightY - PD_SPEED)
    Box HRES -PD_WIDTH, 0, HRES-1, VRES, 0,, C_BG
    Sprite SHOW #2,HRES -PD_WIDTH, rightY, 2,1
  ElseIf k$ = Chr$(130) Then
    rightY =Min(VRES - PD_HEIGHT,rightY +PD_SPEED )
    Box HRES -PD_WIDTH, 0, HRES-1, VRES, 0,, C_BG
    Sprite SHOW #2,HRES -PD_WIDTH, rightY, 2,1
*/
  EndIf
  Pause 18
End Sub


Sub showHelp()
  Text HRES/2,10*FH, "  Cursor up = Paddle up  ", "CT", 3, 1, C_LINE
  Text HRES/2,13*FH, "Cursor down = Paddle down", "CT", 3, 1, C_LINE
  Text HRES/2,16*FH, "'t' = Sound on/off", "CT", 3, 1, C_LINE
  Text HRES/2,19*FH, "'0'-'9' = VOLUME", "CT", 3, 1, C_LINE
  Text HRES/2,22*FH, " 's' = Screenshot   ", "CT", 3, 1, C_LINE
  Text HRES/2,25*FH, "'Space' = pause  ", "CT", 3, 1, C_LINE
  Text HRES/2,28*FH, " Esc = Exit", "CT", 3, 1, C_LINE
  Do :Loop While Inkey$=""
  Sprite HIDE #1
  CLS
  drawField()
  Sprite SHOW #1, 0, leftY,1
End Sub

Sub loadSprites
Local integer x,y,idx,col,bit
  If MM.HRES=640 Then
    hMask%( 0)=&H0
    hMask%( 1)=&H0
    hMask%( 2)=&H0
    hMask%( 3)=&H0
    hMask%( 4)=&H800000000000001
    hMask%( 5)=&HC00000000000003
    hMask%( 6)=&HF8000000000001F
    hMask%( 7)=&HFFC0000000003FF
    hMask%( 8)=&HFFFFC000003FFFF
    hMask%( 9)=&HFFFFFF801FFFFFF

    For x = 0 To PD_WIDTH -1'paddles
      For y = 0 To PD_HEIGHT -1
        idx = y * PD_WIDTH +x
        bit = (hMask%(x) >> (PD_HEIGHT -1-y)) And 1
        pdDataL%(idx) = Choice(bit,RGB(GOLD),C_PD_L)
        pdDataR%(idx) = Choice(bit,RGB(BLUE),RGB(BLUE))
      Next y
   Next x
  Else
    For i = 0 To PD_WIDTH * PD_HEIGHT - 1
      pdDataL%(i) = RGB(red)
      pdDataR%(i) = RGB(blue)
    Next
  EndIf

  Restore witch
  LoadBallFromDatas(altballData%(),BALL_HEIGHT, BALL_WIDTH)
  Restore dots '48x48
  LoadBallFromDatas(ballData%(),BALL_HEIGHT, BALL_WIDTH)

  Sprite LOADARRAY #1, PD_WIDTH  ,PD_HEIGHT, pdDataL%()
  Sprite LOADARRAY #2, PD_WIDTH  ,PD_HEIGHT, pdDataR%()
  Sprite LOADARRAY #3, BALL_WIDTH,BALL_HEIGHT,ballData%()
  Sprite LOADARRAY #4, BALL_WIDTH,BALL_HEIGHT,altballData%()
End Sub

Sub drawField()
  CLS
  For i = 20 To VRES-40*hq Step 80*hq
    Line HRES/2-1,i, HRES/2-1, i+40*hq,3 , C_LINE
  Next
  updateScore()
  Sprite SHOW #1, 0,leftY,2
End Sub

Sub updateScore()
  Text HRES/2-130*HQ, FH, Str$(scoreL%), "CT", 7, 5*HQ, C_PD_L
  Text HRES/2+130*HQ, FH, Str$(scoreR%), "CT", 7, 5*HQ, C_PD_R
End Sub

Sub BallMove
Local nextX, nextY,angleY,radians
  nextX = ballX +ballDX
  nextY = ballY +ballDY
  If nextY < 0 Or nextY >VRES -BALL_HEIGHT Then
    ballDY = -ballDY
    nextY  = ballY+ballDY
     If soundOn% Then
       Play SOUND 1, "M", U, 2.003,VOLUME
       SetTick 150,sound_OFF,4'sound wall
     EndIf
  EndIf
  If nextX<HRES/2 Then
   If nextX<= PD_WIDTH And nextY +BALL_HEIGHT >=leftY And nextY<=leftY +PD_HEIGHT Then
     ballDY = AdjustAngle(nextY, leftY)
     radians= Atn(ballDY / BALL_SPEED)
     ballDX = Cos(radians) * BALL_SPEED
     nextX  = ballX+ballDX
     dir=0
     If soundOn% Then
       Play SOUND 1, "M", U, 1.003,VOLUME
       SetTick 150,sound_OFF,4'sound paddle left
     EndIf
   End If
     If nextX+BALL_WIDTH/2 <0 Then
     Inc scoreR%
     If soundOn% Then sound_beyond()
     updateScore()
     resetBall(-1)
     Exit Sub
   EndIf
  EndIf
  If nextX>=HRES/2 Then
   If nextX + BALL_HEIGHT >= HRES -PD_WIDTH And nextY +BALL_HEIGHT>=rightY And nextY <= rightY + PD_HEIGHT Then
     ballDY = AdjustAngle(nextY, leftY)
     radians= Atn(ballDY / BALL_SPEED)
     ballDX =-(Cos(radians) * BALL_SPEED)
     nextX  = ballX+ballDX
     dir=1
     If soundOn% Then
       Play SOUND 1, "M", U, 1.003,VOLUME'sound paddle right
       SetTick 150,sound_OFF,4
     EndIf
   EndIf
   If nextX >HRES Then
     Inc scoreL%
     If soundOn% Then sound_beyond()
     updateScore()
     resetBall(1)
     Exit Sub
   EndIf
  EndIf
  ballX = nextX
  If ballX>=HRES Then ballX =HRES-1
  ballY = nextY
  If ballY>=VRES Then ballY =VRES-1

  On error skip 9
  If Rnd < 0.1 Then
    Sprite hide #s_activ
    Sprite SHOW #4,Int(ballX), ballY, 1,Choice(dir>0,1,0)
    s_activ=4
  Else
    Sprite hide #s_activ
    Sprite SHOW #3,Int(ballX), ballY, 1,Choice(dir>0,Rnd*2,Rnd*2)
    s_activ=3
  EndIf

End Sub


Sub sound_beyond()'#0
 SetTick pause, sound_OFF
 Play SOUND 1, "M", O
 Math SCALE pout%(),1,packed%()'array copie
 Play SOUND 1, "M", U, 2,VOLUME
 Pause 500
 Play SOUND 1, "M", O
 Math SCALE temp%(),1,packed%()
End Sub

Sub sound_OFF'settick interrupt
  Play SOUND 1, "M", O
End Sub

Sub Opponent
  Local targetY
'Exit Sub
  targetY =ballY +BALL_HEIGHT /2 -PD_HEIGHT /2
  If rightY + PD_HEIGHT / 2 < targetY Then
    rightY =Min(VRES - PD_HEIGHT,rightY +PD_SPEED*HQ -1)
  ElseIf rightY + PD_HEIGHT / 2 > targetY Then
    rightY =Max(0, rightY - (PD_SPEED*HQ -1))
  EndIf
  Box HRES -PD_WIDTH, 0, HRES-1, VRES, 0,, C_BG
  Sprite SHOW #2,HRES -PD_WIDTH, rightY, 2,1
End Sub

Sub resetBall(dir)
Local p,angle,radians
  SetTick pause, BallMove
  ballX = HRES /2-BALL_HEIGHT/2+dir*10
  ballY=BALL_HEIGHT + (VRES - BALL_HEIGHT*2) * Rnd
  angle = (Rnd * 60 - 30)
  If Abs(angle) <5 Then angle =Sgn(angle)*5
  radians = angle * Pi/180
  ballDX = dir * Cos(radians) * BALL_SPEED
  ballDY = Sin(radians) * BALL_SPEED
  If (scoreL%+scoreR%) Mod maxPOINTS = 0 Then Inc BALL_SPEED '
  If BALL_SPEED>SPEED_LIMIT Then gameOver()
  Sprite hide #s_activ
  Sprite SHOW #3, ballX, ballY, 1,Choice(dir>0,0,1)
  Timer = 0
  Do
    getCursor()
  Loop While Timer<1000
  If soundOn% Then
'    Play TONE 150,150,80    'sound new ball
  EndIf
  SetTick resume, BallMove
End Sub

Function AdjustAngle(ballYpos, paddleYpos)
Const maxANGLE=75
Local impact, angle, radians
 ' impact: relative hit position from center of paddle (-1.0 to +1.0)
 impact =(ballYpos +BALL_HEIGHT/2-(paddleYpos+PD_HEIGHT/2))/(PD_HEIGHT/2)
 angle   = impact* maxANGLE
 radians = angle * Pi/180
 AdjustAngle = Sin(radians) * BALL_SPEED
End Function

Sub gameOver()
Local float x,fSode=-1,semitoneRatio=2^(1/12)
Local integer T,j=1
  sound_OFF
  SetTick 0,0,4
  SetTick pause, BallMove

  If scoreL%>scoreR% Then
    Text HRES /2, 10*FH*HQ, "Player 1 WINS!", "CT",3 ,1*HQ, RGB(RED)
  ElseIf scoreL%<scoreR% Then
    Text HRES /2, 10*FH*HQ, "Player 2 WINS!", "CT",3 ,1*HQ, RGB(BLUE)
  Else
    Text HRES /2, 10*FH*HQ, "No one WINS!", "CT",3 ,1*HQ, RGB(MAGENTA)
  EndIf
  Text HRES /2, 20*FH*HQ, "Game over!", "CT",3 ,2*HQ, RGB(Orange)
  Text HRES /2, 34*FH*HQ, "Press ESC to exit", "CT",7 ,2*HQ, RGB(cerulean)
  Text HRES /2, 38*FH*HQ, "or SPACE to start a new game", "CT",7 ,2*HQ, RGB(midgreen)

  k$="":x=2.2
  Restore odem
  Do
    T=cm(1)
    For i=0 To 12-1:cm(i)=cm(i+1):Next
    cm(12)=T
    For i=1 To 12:Map(i)=cm(i):Next
    Map Set
    k$=Inkey$
    If k$=Chr$(27) Then Map RESET: CLS :End
    If k$=" " Then Exit
    If fSode<>0 Then Read fSode
    If fSode>0 Then
      Play SOUND 1, "M", U,2*fSode ,20
      Pause 220
      Play SOUND 1, "M", O
    EndIf
    Pause 30
  Loop
  'REinit new game:
  scoreL% = 0
  scoreR% = 0
  Timer   = 0
  dir     = 0
  ballX   = HRES /2 -BALL_HEIGHT/2
  ballY   = BALL_HEIGHT + (VRES - BALL_HEIGHT*2) * Rnd
  BALL_SPEED=SPEED_REST
  ballDX  = BALL_SPEED
  Map RESET
  remapCol
  CLS
  drawField()
  SetTick resume, BallMove
End Sub

Sub LoadBallFromDatas(spriteArray%(),spriteHeight%,spriteWidth%)
Local rowIndex%, colIndex%, idx%
Local header$, rowStr$, char$, val%
'Local integer cm(15)=(0,1,6,7,8,9,14,15,2,3,4,5,10,11,12,13)
Local integer cm(15)=(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)'color map
Read header$
idx% =0
For rowIndex% = 0 To spriteHeight% - 1
  Read rowStr$
  For colIndex% = 1 To spriteWidth%
    If colIndex% <= Len(rowStr$) Then
      char$ = Mid$(rowStr$, colIndex%, 1)
    Else
      char$ ="0"
    End If
    val% = cm(Val("&H" + char$))
    spriteArray%(idx%) = Map(val%)'RGB121to888(val%)
    Inc idx%
  Next
  Print
Next
End Sub

Sub remapCol
  Map(11)=RGB(128,128,128)
  Map set
End Sub

witch:
Data "48,1,48"
Data "000000000000000000000999"
Data "0000000000000000000009999"
Data "00000000000000000000999999"
Data "0000000000000000000991111199"
Data "0000000000000000000911AAA1999"
Data "00000000000000000099AAAAAA1999"
Data "000000000000000009991111111A999"
Data "000000000000000009999AAAAAAAA199"
Data "0000000000000000000099AAAAAA11999"
Data "00000000000000000000099111111999999"
Data "00000000000000000000099111111AAA99999"
Data "00000000000000000000099AAAAAAAAA9999"
Data "0000000000000000000999AAAAAAAA1999"
Data "000000000000000000999AAA999999999"
Data "00000000000000000999999999999999"
Data "0000000000000000999999999FFFFFF"
Data "000000000000000099CCCCCCFF11FFF"
Data "000000000000000000CCCCCCFF11FFFF"
Data "000000000000000CCCCCCCCFFFFFFFFF"
Data "00000000000000000CC00CCFFFFDFF"
Data "000000000000000CCCC0CCCFFFFDDD"
Data "000000000000000CC00CCCCFFFFFF"
Data "000000000000000000CCC000FFFF"
Data "00000000000000000CCCC0999999"
Data "000000000000000000000999999999"
Data "000000000000000000000999999999"
Data "0000000000000000000099991111999"
Data "000000000000000000099991119999900000000000000004"
Data "000000000000000000099991111119900000000000044444"
Data "0000000000000000000999791111177FF00000000444444"
Data "0000000000000000000999971111111FFFF000444444"
Data "0000000000000000009999979111111FFF4444444"
Data "0000000000000000009999997111111FF444444"
Data "0000000000000000009999999779111FFF4"
Data "00000000000000000999999999977774F"
Data "00000000000000099999995599559999"
Data "0CCCCCCCC00000999999995599559999"
Data "CCCCCCCCCCCC00999999995555559999"
Data "004C4444CCCCC9994999995555559999"
Data "000000CCCCCCC444449999BB55BB99"
Data "0CCCCCCCCCCCC44499000BBBBBBB"
Data "000CC4444CCCC49900000BBBBBBB00EE"
Data "000004444CCCC90000000BBBB0BBBEE000EE"
Data "CCCCCCCCCCCCC000000000BEE0BBB000EEE"
Data "0CCCCCCCCCCC0000000000EEEEBBB0EEEE"
Data "00000000CC000000000000EEEEEEEEEEE"
Data "00CCCCCCC0000000000000EEE0EEEEE"
Data "0000CCCC"
globe:
Data "48,1,48"
Data "000000000000000000AA7AAAAAAA7AA"
Data "000000000000000AAAAAAAAAAAAAAAAAA7"
Data "000000000000AAAAAAAAA777AAAAAAAAA777"
Data "00000000000AAAAAAAA77777AAAA7AA7777777"
Data "000000000AAAAAA77AA7777777777AA77777777"
Data "00000000AA7777777777777777777777777777777"
Data "0000000AA77777777777777777777777777AAAAA7A"
Data "000000A777777777777777777777777A77AAAAAAAAA"
Data "000007AA777777777777777777777AAA77AAA7AAAAAA"
Data "00000777777777777777777777777AAA7AAA77AAAAAA"
Data "00007777777777777777777777777AAAAA8AAAAAAAAAA"
Data "000A777777777777777777777777A7AAAAAAAAAAAAAAA"
Data "000A77777777777777777777777AAAAAAAAAAAAAAAAAAA"
Data "000AA777777777777777777777AAAAAAAAAAAAAAAAAAAA"
Data "00AAAA777777777777777777777AAAAA7AAAAAAAAAAAAAA"
Data "00AAAA777777777777777777AAAAAA7777A7AAAA7AAA7AA"
Data "000AAA7777777777777777AAAAAAAAAAAAAAAAA777AA7A7"
Data "0AA0AA77777777777777AAAAAAAAAAAAAA77AA7AAAAA77AA"
Data "0AAA0A7777777777777AAAAAAAAAAAAAAAA7777AAAAA77AA"
Data "AAAAA07777777777777AAAAAAAAAAAAAAAA7AA777AAAA7AA"
Data "AAAAAA077777777777AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
Data "AAAAAAA0777777777AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
Data "AAAAAAA7077777777AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
Data "AAAAAAA7707777777AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
Data "AAAAAAAA7707777777AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
Data "AAAAAAAAA770777777AAAAAAAAAAAAAAAAAAAAAAA7AAAAA7"
Data "AAAAAAAAA7777077777AAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
Data "AAAAAAAAA77777707777AAAAAAAAAAAAAAAAAAAAAAAAAAAA"
Data "0AAAAAAAA7777777707777AAAAAAAAAAAAAAAAAAAA7AAAA7"
Data "0AAAAAA7777777777770777777AAAAAAAAAAAAAAAAAAA777"
Data "00AAAAA77777777777777007777AAAAAAAAAAAAAAAAAA77"
Data "00AA77777777777777777777007AAAAAAAAAAAAAAAAAA77"
Data "00AAA777777777777777777777A00AAAAAAAAAAAAAAA777"
Data "000A77777777777777777777777AAA0A0AAAAAAAAAAAA77"
Data "000A77777777777777777777777AAAAAAA00A0A0007007"
Data "000A77777777777777777777777AAAAAAAAAAAAA777777"
Data "000077777777777777777777777AAAAAAAAAAAA777777"
Data "00000777777777777777777777AAAAAAAAAAAA777777"
Data "000000777777777777777777AAAAAAAAAAAAAA77777"
Data "000000777777777777777777AAAAAAAAAAAAAA77777"
Data "000000077777777777777777AAAAAAAAAAAAAAAA77"
Data "000000007777777777777777AAAAAAAAAA77AA777"
Data "00000000077777777777777AAAAAAAAAA77A7777"
Data "00000000000777777777777AAAAAAAA777A777"
Data "00000000000077777777777AAAAAA7777777A"
Data "00000000000000077777777AAAA7777777"
Data "0000000000000000007777777777777"
Data "00000000000000000000777777777"
bear:
Data "24,1,32"
Data "0000AAAAAAA00000000000AAAAAAA"
Data "000AAAAAAAAA0002A2000AAAAAAAAA"
Data "00AAFFFFFAAAAAAAAAAAAAAFFFFFAAA"
Data "0AAFFFFFFFAAAAAAAAAAAAAFFFFFFAAA"
Data "0AAFFFFFAAAAAAAAAAAAAAAAAFFFFFAA"
Data "0AAFFFFAAAAAAAAAAAAAAAAAAFFFFFAA"
Data "0AAFFFAAAAAAAAAAAAAAAAAAAAFFFFAA"
Data "0AAFFAAAAAAAAAAAAAAAAAAAAAAFFFAA"
Data "0AAFFAAAAAAAAAAAAAAAAAAAAAAAFFAA"
Data "00AAFAAAAAAAAAAAAAAAAAAAAAAAFAA"
Data "00AAAAAAAAA112BAAAAAA1AAAAAAAAA"
Data "000AAAAAAAA11AAAAAA111AAAAAAA"
Data "0000AAAAAAA11AFAAAA111AAAAAAA"
Data "0000AAAAAAAAFF0000AFBAAAAAAAA"
Data "0000AAAAAAAFFF00000FFAAAAAAAA"
Data "0000AAAAAAFFFF0000BFFFAAAAAAA"
Data "0000AAAAAAFFFFFB0FFFFFFAAAAAA"
Data "0000AAAAAAFB0FFF0FFFAAFAAAAA"
Data "00000AAAAAFF0AB00B2A0FFAAAAA"
Data "000000AAAAAFF200F00FFFAAAAA"
Data "0000000AAAAFFFFFFFFFFAAAAA"
Data "00000000AAAAAFFFFFFAAAAAA"
Data "00000000000AAAAAAAAAAA"
Data "0000000000000AAAAAAA"

rabbit:
Data "48,1,43"
Data "FFFB"
Data "BFFFF000000000000000000000000000000222"
Data "2FFFFF2000000000000000000000000000FFFFF"
Data "2ABBFFFB200000000000000000000000FFBA8AFB"
Data "0AAAAFFFFB00000000000000000000FFFAAAAAFB"
Data "0AAAAAFFFFFB00000000000000002FFFAAAAAAF"
Data "0AAAAAAFFFFFB000000000000002FFFAAAAAAAF"
Data "0AAAAAAAFFFFFB0000000000000FFFB8AAAAABF"
Data "00AAAAAABFFFFFF00000000000FFFFBAAAAAAFB"
Data "00AAAAAAAFFFFFFB000000000FFFFFFAAAAAAF2"
Data "002AAAAAAAFFFFFFB00000000FFFFFAAAAAABF"
Data "000AAAAAAABFFFFFF20000000FFFFFBAAAAAB2"
Data "0002BAAAAAAFFFFFFB0000000FFFFFBAAAAFB"
Data "0000BBBAAAAAFFFFFF2000002FFFFFFAAABB"
Data "000002BBAAAAFFFFFFB200002BFFFFFAA"
Data "0000002BBAAAFFFFFFFB00BFBFFFBFBA"
Data "000000002BBBBFFFFFFFFFFFFFFFFFF2"
Data "00000000002BFFFFFFFFFFFFFFFFFFFF2"
Data "000000000000FFFFFFFFFFFFFFFFFFFFFF"
Data "000000000000FFFFFFFFFFFFFFFFFFFFFF"
Data "00000000000FFF02FFFFFFFFFFFFFFFFFFB"
Data "0000000000FFF0000FFFFFFFFFFFFFFFFFF"
Data "000000000BFF000002FFFFFFFFFFFF00FFF"
Data "000000000FF202FB00FFFFFFFFFFF2000BFB"
Data "000000000FF0BFFFB2FFFFFFFFFFF00200FF"
Data "00000000BFB2FFFFFBFFFFFFFFFFF02FB02F"
Data "00000000FFBBFFFBFBFFFFFFFFFFFBFFFB0F"
Data "00000002FFBFF010BFFFFFFFFFFFBFFFFF2B"
Data "000000AFFFFF22B13FFFFFFFFFFFFF311FBF"
Data "00000FFFFFBB3FF11BFFFFFFFFFFF1111BBF2"
Data "0000FFFFFFF311111BFFFFFFFFFF1BB11BBFB"
Data "000FFFFFFFFF11110FFFFFFFFFFF111113FFFB"
Data "000FFFFFFFFFB1112FFFFFFFFFFF111112FFFFFF"
Data "00FFFFFFFFFFFF33BFFFFFFFFFFF3111BFFFFFFFB"
Data "00FFFFFFFFFFFFFFFFFFFFFFFFFFB03FFFFFFFFFF"
Data "00BFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF2"
Data "000FFFFFFFFFFBBFFFFA0ABB20FFFFFFFFFFFFFFFB"
Data "0002FFFFFFFFB00BBFFFA0000AFFFFBBFFFFFFFFF2"
Data "0000AFFFFFFFFA00BFFFFB02BFFFFA2AFFFFFFFFF"
Data "00000BFFFFFFFFA02FFFBBBBBFFB20ABBFFFFFFF"
Data "0000000BFFFFFFFA00B22B222BB00ABFFFFFFFB"
Data "00000000BFFFFFFFB0888FFF8000BFFFFFFFF2"
Data "000000000BFFFFFFFB8888A888ABFFFFFFFB"
Data "0000000000BFFFFFFFBA8888ABFFFFFFFB"
Data "0000000000002FFFFFFFFFFFFFFFFFFB2"
Data "00000000000000BBFFFFFFFFFFFFB2"
Data "000000000000000000BFFFFFBB22"
Data ""
rabbit2:
Data "48,1,48"
Data "00FFFF2"
Data "02FBBBFB"
Data "0FBA8AFFF"
Data "0FA8888FFF00000000000000000000000000FFFFFF"
Data "2B888888FFF000000000000000000000BFFFFFFF"
Data "BB8888802FFB0000000000000000002FFFFFBA088A"
Data "FB8888880FFFA0000000000000000FFFFFF088888"
Data "FB88888880FFF000000000000000FFFFFB088888"
Data "BB888888800FFFB00000000000FFFFFFF0888888"
Data "AB8888888A0FFFF00000000000FFFFFFB088888"
Data "2FA888888A02FFFF000000000FFFFFFF088888"
Data "0FB888888A00FFFF000000002FFFFFF088888"
Data "0FB888888A80FFFFB0000000FFFFFF0888888"
Data "02B888888AA0FFFFF0000002FFFFFF088888"
Data "00FB88888AA0BFFFF2000002FFFFF28888"
Data "00FB888888A02FFFFF00000BFFFFF0888"
Data "000FBA8888A00FFFFF00000BBFFFB"
Data "0000FB8888880FFFFF202BBFFFFFFFFFF2"
Data "00002FB888000FFFFF22FFFFFA2FFFFFFFFB"
Data "00000BBB88800BFFFFBFFFF00002FFFFFFFFF"
Data "000000FFB88002FFFFFFFF200000BFFFFFFFFF"
Data "0000000FFFFF00FFFFFFFF0000FB2FFFFFFFFF2"
Data "00000000BFFFB0BFFFFFFA00AFFFFFFFFFFFFFFF"
Data "000000000AFFFF2FFFFFF00AFFFFFFFFFFFFFFFF"
Data "000000000000FFFFFFFFFBFFF000BFFFFFFFFB0BB"
Data "0000000000000FFFFFFFFFFF02FB0AFFFFFFF231B2"
Data "000000000000FFFFFFFFFFF02FFFF0FFFFFFF013F3"
Data "000000000002FFFFFFFFFFF0FF3130AFFFFFF01133"
Data "00000000000BFFFFFFFFFFB0FB11F02FFFFFF23111"
Data "00000000000FFFFFFFFFFFB0F111100FFFFFF23111"
Data "00000000000FFFFFFFFFFFF0F111102FFFFFFF0111"
Data "00000000002FFFFFFFFFFFF0F31110BFFFFFFF011B2FA"
Data "0000000000AFFFFFFFFFFFFA00000FFFFFFFFFFFFFFFFF2"
Data "00000000002FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFBA"
Data "00000000002FFFFFFFFFFFFFFFFFFFFFFFFFFBAFFFF2FFFA"
Data "00000000000FFFFFFFFFFFFFFFFFFFFFFFFFFF00AF0AFFFA"
Data "00000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF2002FFFF2"
Data "00000000000FFFFFFFFFFFFFFFFF20BFFFFFFFFFAAFFFFFF"
Data "00000000000FFFFFFFFFFFFFFFF000FFFFFFFFFFABFFFFF2"
Data "00000000000FFFFFFFFFFFFFFFFFF02FFFFFFFFF0FFF2FF"
Data "000000000002FFFFFFFFFFFFFFFFF20000222002B00BFB"
Data "000000000000BFFFFFFFFFFFFFFFFF080000AFBFF2FFF"
Data "0000000000000BFFFFFFFFFFFFFFFF288800FFBFBAFF"
Data "00000000000000BFFFFFFFFFFFFFFFF08880FFBF0FB"
Data "000000000000000BFFFFFFFFFFFFFFFF08800000B2"
Data "00000000000000000BFFFFFFFFFFFFFFF2002FFA"
Data "00000000000000000002FFFFFFFFFFFFFFFFFF2"
Data "0000000000000000000000BFFFBA02BFFFFFF"
strawberry:
Data "48,1,43"
Data "0000000000000000000000000000BBB000022"
Data "0000000000000000000000000000B6600020200B2"
Data "000000000000000000BB0000000BE6600020000B002"
Data "000000000000000000EFB000000B66602200B2B20B"
Data "00000000000002BBBB666BBB002B666200BB2B"
Data "0000000000000002BB6666AABB32666300B2F00B"
Data "00000000000000000B666666B30066633A3FB02"
Data "0000002BBBBBBBB333666666600266223BBB00002B"
Data "000000BBBEEE6233336666666232666BAAB00002"
Data "000000000EEE2222226666662B326622A2000B2"
Data "00000BEEEEAEE662226622222222E6EEE20012"
Data "000000BBEEEEEEEE622666222222266EEE1313B"
Data "0000000BEEEE88AA2A662666622EEEEEEE0031BB"
Data "000000BB88888A22662262EEEAAAAEEEEA8888A8B"
Data "000000B88888EEE222222888888888AA88888888BB"
Data "000000BA8888EEEEEEEEA88888888888888888888B"
Data "00000B88888AAAAAAAA8888888888888888B88888BB"
Data "00000B888EAAAAAAAAA888888B8888888B8888888AB"
Data "0000BBA88FAAA88888A888888A8888888F8888FFB8B"
Data "0000B8888F8A888888888B888888FB888888888B8AB"
Data "000BB888888E888A8888BF8888888A88888888888BB"
Data "000BA8A88888A88E8A888A888A8888888B8FF8888BB"
Data "000B8AAABF88ABF88A88888888FFB888888B888888B"
Data "000B8AAABF88ABF88A88888888FFB888888B888888B"
Data "000B8A88AA88AAA888B8A8888A8FB8888888888A88B"
Data "000B8B8AA888EAA888B88FBB8A8B88888888888888B"
Data "0000B8BEFA88888888FAABFFA88A88AB88888A88AB"
Data "0000BAF88AA8888888FF8888888A888F888A8A88AB"
Data "0000BB8A8AAA888A88BFAA88888888AB888888888"
Data "000002AA88A88AFA8888B888B8888888888888BAB"
Data "00000BBAABABFA888A888888F888AA888888A88BB"
Data "000000BA8BAFF8A88AA88888A8888FF8888BFA8B222"
Data "000000BBAA8A88BAABF8A888888A888AA8888BBBB"
Data "0000000BAA8A8FAAA8888888888A888B8888ABAB"
Data "0000000BBB8AAAA888A8F8888FB8888F888AABB"
Data "000000000BABAAA8AA8AA8888A8888AA8B8BAABB"
Data "000000000BABAAA8FF8AAA888888A888AABBBBB"
Data "0000000000BF8AAA8888AA888A888888B8BBBB"
Data "00000000000BABA8AABA8ABBA8AA8888ABBBB"
Data "000000000000BFBA8AAAB888FAA8AFA8ABB2B"
Data "000000000000BBBABB88BA888ABAAB8AAB2B"
Data "000000000000000BABBBBBAAB888BA8BABB"
Data "000000000000000BBBFBBF88AB88888BBB"
Data "0000000000000000BB8ABBBBAA8BBBBBBB"
Data "0000000000000000002BB8AAFFBBBB22"
Data "00000000000000000000BBBBBB8BBBB"
Data "0000000000000000000001BBBBB211"
Data ""

'pong sound
pong:
Data &H800,&HFFF,&HFFF,&HE2B,&H417,&H3DB,&H247,&H415,&H465,&H75D,&HBB6,&HB63,&HDC9,&HC09,&HC7B,&H402
Data &H000,&H000,&H50F,&HFFF,&HFFF,&HFA0,&H564,&H3D8,&H2E0,&H3AC,&H4C9,&H641,&HB6E,&HAF9,&HD6E,&HC09
Data &HC82,&H631,&H000,&H000,&H296,&HFFF,&HFFF,&HFFF,&H6FF,&H3C6,&H386,&H350,&H51F,&H575,&HADC,&HACD
Data &HCDC,&HC31,&HC3B,&H820,&H000,&H000,&H0B3,&HE46,&HFFF,&HFFF,&H8C4,&H3CB,&H419,&H31B,&H54E,&H504
Data &HA09,&HACF,&HC2B,&HC68,&HBD4,&H9AB,&H099,&H000,&H000,&HBC8,&HFFF,&HFFF,&HA86,&H407,&H483,&H31F
Data &H549,&H4E9,&H90A,&HAE4,&HB79,&HC90,&HB73,&HABE,&H23F,&H000,&H000,&H93C,&HFFF,&HFFF,&HC1D,&H490
Data &H4BB,&H35B,&H518,&H50F,&H800,&HAEC,&HAE0,&HC92,&HB34,&HB59,&H401,&H000,&H000,&H6D1,&HFFF,&HFFF
Data &HD6A,&H56D,&H4C7,&H3C4,&H4CA,&H558,&H70C,&HACE,&HA73,&HC64,&HB1F,&HB89,&H5C2,&H000,&H000,&H4B1
Data &HF70,&HFFF,&HE5F,&H692,&H4BC,&H443,&H47B,&H5A3,&H64C,&HA7A,&HA3A,&HC06,&HB31,&HB6C,&H760,&H094
Data &H000,&H2FD,&HDCC,&HFFF,&HEFA,&H7E6,&H4B3,&H4BF,&H440,&H5D9,&H5D0,&H9EE,&HA2C,&HB86,&HB59,&HB25
Data &H8BD,&H1A4,&H000,&H1C3,&HBEE,&HFFF,&HF49,&H94A,&H4CA,&H524,&H42C,&H5EA,&H59B,&H935,&HA38,&HAF8
Data &HB80,&HAD3,&H9C4,&H2DC,&H011,&H104,&H9F3,&HFF7,&HF5F,&HA9B,&H515,&H563,&H445,&H5D3,&H5A2,&H867
Data &HA46,&HA75,&HB93,&HA93,&HA6A,&H433,&H09C,&H0B0,&H800,&HF46,&HF50,&HBBE,&H5A1,&H57C,&H487,&H5A0
Data &H5D0,&H79D,&HA40,&HA0E,&HB82,&HA72,&HAB7,&H594,&H131,&H0AE,&H637,&HE59,&HF2C,&HC9F,&H66A,&H57A
Data &H4E4,&H560,&H60D,&H6F1,&HA14,&H9CD,&HB4B,&HA72,&HABC,&H6E7,&H1DA,&H0E5,&H4B7,&HD2E,&HEFC,&HD3B
Data &H764,&H570,&H548,&H528,&H641,&H675,&H9BC,&H9B3,&HAF2,&HA8B,&HA91,&H813,&H29E,&H13A,&H392,&HBCE
Data &HEBD,&HD94,&H877,&H573,&H5A2,&H508,&H65D,&H630,&H93C,&H9B4,&HA87,&HAAC,&HA52,&H903,&H382,&H19E
Data &H2CF,&HA4B,&HE69,&HDB9,&H988,&H597,&H5E2,&H50A,&H65B,&H620,&H8A1,&H9C1,&HA1B,&HAC4,&HA18,&H9AA
Data &H483,&H208,&H265,&H8C0,&HDF4,&HDBA,&HA7E,&H5EA,&H604,&H52F,&H63C,&H637,&H7FF,&H9C6,&H9BE,&HAC6
Data &H9F1,&HA08,&H594,&H277,&H247,&H748,&HD54,&HDA5,&HB48,&H670,&H60C,&H56E,&H60E,&H663,&H76C,&H9B3
Data &H97C,&HAA9,&H9E5,&HA25,&H6A4,&H2F2,&H25E,&H5FE,&HC83,&HD84,&HBDD,&H722,&H605,&H5BB,&H5DD,&H691
Data &H6F7,&H980,&H959,&HA70,&H9F0,&HA13,&H79F,&H37F,&H296,&H4F6,&HB84,&HD5A,&HC3B,&H7F0,&H600,&H607
Data &H5B9,&H6B2,&H6AC,&H92B,&H951,&HA23,&HA08,&H9E8,&H873,&H424,&H2E0,&H437,&HA62,&HD22,&HC6B,&H8C8
Data &H60D,&H644,&H5AD,&H6BC,&H68C,&H8BB,&H958,&H9CD,&HA1F,&H9B7,&H912,&H4E2,&H330,&H3C3,&H92E,&HCD4
Data &HC78,&H994,&H63B,&H66A,&H5BD,&H6AE,&H690,&H83E,&H961,&H97D,&HA2B,&H990,&H977,&H5B2,&H384,&H390
Data &H800,&HC69,&HC6F,&HA45,&H690,&H679,&H5E5,&H68F,&H6AC,&H7C4,&H95D,&H93F,&HA21,&H97C,&H9A6,&H688
Data &H3DF,&H38F,&H6EB,&HBD9,&HC5A,&HACE,&H70A,&H678,&H61D,&H668,&H6D1,&H75B,&H943,&H918,&H9FF,&H97C
Data &H9A8,&H756,&H445,&H3B0,&H602,&HB24,&HC3C,&HB2C,&H7A1,&H672,&H65A,&H646,&H6F1,&H710,&H90D,&H907
Data &H9C9,&H98B,&H98E,&H80B,&H4BC,&H3E4,&H550,&HA4E,&HC16,&HB62,&H848,&H673,&H690,&H633,&H702,&H6E7
Data &H8BF,&H908,&H988,&H99F,&H968,&H89D,&H546,&H421,&H4D9,&H964,&HBE3,&HB79,&H8ED,&H68A,&H6B7,&H634
Data &H700,&H6DD,&H862,&H910,&H947,&H9AD,&H945,&H902,&H5E2,&H461,&H49A,&H874,&HB9C,&HB79,&H983,&H6BC
Data &H6CC,&H64A,&H6EE,&H6EB,&H7FF,&H913,&H90E,&H9AE,&H92D,&H93B,&H688,&H4A4,&H487,&H790,&HB3B,&HB6D
Data &H9FE,&H70D,&H6D0,&H671,&H6D1,&H705,&H7A6,&H908,&H8E7,&H99D,&H926,&H94D,&H72D,&H4EF,&H495,&H6C8
Data &HABC,&HB58,&HA58,&H779,&H6CC,&H6A0,&H6B4,&H721,&H75F,&H8E9,&H8D1,&H97B,&H92C,&H942,&H7C5,&H545
Data &H4B7,&H628,&HA22,&HB3E,&HA91,&H7F6,&H6C9,&H6CD,&H69E,&H735,&H732,&H8B5,&H8CC,&H94B,&H93B,&H928
Data &H845,&H5A9,&H4E4,&H5B4,&H972,&HB1D,&HAAE,&H879,&H6D1,&H6F2,&H697,&H73B,&H71E,&H871,&H8D1,&H917
Data &H949,&H90A,&H8A6,&H61C,&H515,&H56E,&H8B7,&HAEE,&HAB6,&H8F5,&H6ED,&H709,&H6A0,&H733,&H721,&H825
Data &H8D6,&H8E7,&H950,&H8F2,&H8E3,&H69A,&H548,&H54F,&H800,&HAAD,&HAB0,&H960,&H720,&H713,&H6B9,&H720
Data &H732,&H7DB,&H8D3,&H8C1,&H94A,&H8E6,&H8FF,&H71C,&H57F,&H54E,&H758,&HA55,&HAA3,&H9B3,&H76B,&H712
Data &H6DB,&H708,&H748,&H79C,&H8C3,&H8A9,&H936,&H8E6,&H901,&H798,&H5BC,&H562,&H6CA,&H9E8,&HA91,&H9EC
Data &H7C6,&H70E,&H700,&H6F4,&H75B,&H76E,&H8A3,&H8A0,&H915,&H8EF,&H8F1,&H807,&H605,&H582,&H65F,&H966
Data &HA7A,&HA0D,&H82B,&H70F,&H721,&H6E8,&H766,&H755,&H874,&H8A0,&H8EE,&H8FB,&H8DA,&H85F,&H659,&H5A7
Data &H617,&H8D8,&HA5C,&HA1B,&H890,&H71D,&H738,&H6E9,&H765,&H74F,&H83B,&H8A5,&H8C6,&H904,&H8C5,&H89C
Data &H6B7,&H5CD,&H5F0,&H846,&HA30,&HA1B,&H8EA,&H73B,&H745,&H6F6,&H75A,&H758,&H7FF,&H8A7,&H8A4,&H905
Data &H8B7,&H8BF,&H71B,&H5F6,&H5E5,&H7BC,&H9F5,&HA13,&H935,&H76D,&H748,&H70E,&H748,&H768,&H7C9,&H8A0
Data &H88C,&H8FA,&H8B2,&H8CA,&H780,&H624,&H5ED,&H743,&H9A9,&HA07,&H96B,&H7AE,&H745,&H72A,&H736,&H779
Data &H79E,&H88D,&H87F,&H8E5,&H8B6,&H8C3,&H7DC,&H658,&H602,&H6E1,&H94B,&H9F8,&H98E,&H7FA,&H743,&H746
Data &H729,&H785,&H783,&H86E,&H87C,&H8C9,&H8BF,&H8B3,&H82A,&H694,&H61D,&H69B,&H8E0,&H9E3,&H9A0,&H849
Data &H748,&H75C,&H725,&H788,&H777,&H845,&H87E,&H8A9,&H8C8,&H8A1,&H864,&H6DA,&H63B,&H671,&H86F,&H9C7
Data &H9A5,&H894,&H759,&H76A,&H72B,&H783,&H778,&H817,&H881,&H88C,&H8CC,&H893,&H88A,&H726,&H659,&H65E
Data &H800,&H99F,&H9A1,&H8D5,&H778,&H770,&H739,&H778,&H783,&H7E9,&H880,&H875,&H8C8,&H88B,&H89B,&H775
Data &H67B,&H65E,&H79A,&H96A,&H999,&H908,&H7A5,&H770,&H74E,&H76A,&H790,&H7C3,&H876,&H867,&H8BC,&H88B
Data &H89C,&H7C1,&H6A0,&H66A,&H744,&H928,&H98F,&H92A,&H7DD,&H76D,&H764,&H75D,&H79C,&H7A7,&H863,&H861
Data &H8A8,&H891,&H892,&H804,&H6CC,&H67D,&H703,&H8D9,&H981,&H93E,&H81A,&H76E,&H778,&H756,&H7A2,&H798
Data &H846,&H861,&H890,&H898,&H884,&H839,&H6FF,&H693,&H6D7,&H883,&H96E,&H947,&H857,&H776,&H787,&H757
Data &H7A2,&H795,&H824,&H864,&H878,&H89E,&H877,&H85F,&H738,&H6AB,&H6BF,&H82A,&H954,&H947,&H88E,&H789
Data &H78E,&H75F,&H79B,&H79A,&H7FF,&H865,&H863,&H89E,&H86F,&H874,&H775,&H6C3,&H6B9,&H7D7,&H930,&H942
Data &H8BB,&H7A6,&H790,&H76D,&H790,&H7A3,&H7DF,&H861,&H854,&H898,&H86C,&H87A,&H7B2,&H6DF,&H6BE,&H78D
Data &H901,&H93B,&H8DC,&H7CE,&H78E,&H77E,&H786,&H7AE,&H7C5,&H855,&H84D,&H88B,&H86E,&H876,&H7EA,&H6FE
Data &H6CA,&H752,&H8C8,&H931,&H8F1,&H7FC,&H78D,&H78F,&H77E,&H7B5,&H7B4,&H842,&H84B,&H87A,&H874,&H86C
Data &H819,&H723,&H6DB,&H727,&H888,&H925,&H8FC,&H82C,&H790,&H79C,&H77B,&H7B7,&H7AD,&H829,&H84C,&H866
Data &H879,&H861,&H83D,&H74E,&H6ED,&H70E,&H843,&H913,&H8FF,&H85A,&H79B,&H7A5,&H77E,&H7B4,&H7AE,&H80D
Data &H84E,&H855,&H87B,&H859,&H853,&H77C,&H700,&H702
Data &H800,&H8FC,&H8FD,&H881,&H7AD,&H7A8,&H787,&H7AD,&HFFFF

Lout:
Data &H02250BBD0FA107E8,&H09760FC50A490132,&H0F3B0C4A02C100E6,&H0DCD0498004C0739
Data &H0686004805350E2D,&H00BE03C00CC70EC9,&H02790B330F460861,&H09960F520A0C018F
Data &H0F040B76029C0193,&H0C9903C80108080B,&H04FB00CA06A40E73,&H00CC056D0DB80D74
Data &H046B0CE50E0D0624,&H0C0B0E6D073600FC,&H0E9E082A014C039C,&H08FC01AE03780B38
Data &H021802FE0A750EAD,&H02A509C70EA209AA,&H09330E880A360280,&H0E650AA102E00269
Data &H0AF00333024508BA,&H03750232085C0E3F,&H022E081B0E1C0B23,&H07F40DFE0B3E03A5
Data &H0DE60B4203C10237,&H0B3103CB024A08E1,&H03C2026708F60DD6,&H029009230DCC0B0B
Data &H09650DC70AD103A8,&H0DC40A82038102C6,&H0A1D034E030B09BC,&H031403620A250DBE
Data &H03CF0A9C0DB209A1,&H0B1D0D9A090F02D9,&H0D0D086702A40455,&H07AB027A04F60BA1
Data &H026705B30C230C9D,&H068D0C970C0B06DF,&H0CF30B5206080271,&H0A71053102A4077F
Data &H0464030808840D2B,&H03A209910D32096B,&H0A980CFD084603B1,&H0C81071003290477
Data &H05DA02CF05840B86,&H032F06C00C450BBB,&H081C0CBF0AAB04BC,&H0CDD095E03D203EB
Data &H07E803390501097E,&H030B06620AC70C90,&H07F30BD10BD00668,&H0C780AA40507035B
Data &H092103F30431098B,&H0358057F0AF70C9A,&H07250C000B440770,&H0C7609C805C80359
Data &H07FC046C040508EE,&H039A05510A930C37,&H07120BC80B3C0627,&H0C4A09A5049F0384
Data &H07B303B6043E08FF,&H03AA05B40AB80BF2,&H07A50BDC0ABF05C9,&H0C1D08E80455048E
Data &H06D203B8063D0B04,&H042908590BF60B5B,&H0A570BD609B80500,&H0A9C079603F6059B
Data &H058A040A07B40BA7,&H054909DC0BD90895,&H0B660ACD06580436,&H08CC049F0410075D
Data &H040B0536099E0BC6,&H090F0B440ACA067C,&H0BA908BE04B304E0,&H0662042806DD0AF6
Data &H052009430BA20A99,&H0B140ABE087104A6,&H089D0611044E0743,&H0486058F09AC0B7D
Data &H07E50B410A40062C,&H0B3507E504930491,&H058F04A5063A0A37,&H06680A4E0B5C0982
Data &H0B540AAD06FB0477,&H087D04FA053E08F6,&H04A607840AE60A6E,&H09FE0B13081205FD
Data &H095405A304A4063C,&H04A5054E08D30B2D,&H079C0ACE0A4A06B5,&H0ADD07DB04E405C7
Data &H057B052008530A16,&H074B0A8D0A7308EB,&H0ADA0814064804D4,&H059D04DB066909E0
Data &H05BB09160AF508F6,&H0AD109AD064904ED,&H070204ED069A0848,&H060409500A7F0A35
Data &H0ACE0A8B07B6051B,&H085A056A059808AE,&H055308160AA209C5,&H0A600A1F07170510
Data &H07940532062F078D,&H05E208E80A120A5B,&H0A9E0A7F08030562,&H0861059A05AC0885
Data &H0588082F0A80099C,&H0A5F09CC06E105D2,&H071E0544057407E8,&H068407AF0A3D09ED
Data &H0A760A01074E0554,&H07720565066B0946,&H065E092C0A70089A,&H0A6708A505F90574
Data &H060205AD065B091D,&H081609180A5E08A4,&H0A530898060305B9,&H05FE05CA08280A3A
Data &H08440A3909610881,&H093C06A205F305E2,&H05A00780086B0A39,&H09F40A38090D067F
Data &H08D3065705BA07BB,&H05DC07FF0A080986,&H0A17094706D0062D,&H068D05BB060B084C
Data &H07DF089F0A1D08FA,&H0A15089F064D05E1,&H0614061908450A04,&H08AE0A0C08E20837
Data &H086F063F06020667,&H064F087E091509FD,&H09F809D107F00603,&H076A05E106B808F6
Data &H073A096009CF0802,&H097E076F05EA05E1,&H05EB074607CE09B1,&H09B309DC090706E1
Data &H086F066A061E07E8,&H0684088D09D808E3,&H09C2083C0652063C,&H060F06B808C10922
Data &H095109A2096C0787,&H073806DC060E0762,&H0659082309AA092D,&H09B8087F0697062F
Data &H063206A4088908DC,&H09340994096E07B3,&H073906F00624075A,&H07E4083109990915
Data &H099A084F068D0652,&H063606E708BB09A2,&H095C095607B10770,&H06DD0641065107BF
Data &H086D08A3099508A4,&H094D07B9065806B7,&H0651078C09300965,&H098408BC070506DD
Data &H066B06B506D30880,&H09250958094707C9,&H06FE06E206600792,&H06EF088F097708A4
Data &H092507A4066C06D8,&H067F07CA09380946,&H0965085E084806C2,&H066A0668073508C8
Data &H0840095908DD0752,&H07DB069306BF0831,&H07AD09150934092F,&H086006E906860687
Data &H073908B508B90953,&H08C208C1074A067D,&H069506E808510949,&H0925090307AE0695
Data &H06C206B707F507F0,&H08F40926092A0808,&H06F306FB069D07A3,&H075D08BA0936084B
Data &H0887072C0698076B,&H0737088E09350878,&H08A50752069D069D,&H07220870085B092D
Data &H08B208C6078006A7,&H06B5070608470924,&H091608C8078C06AF,&H06BC070A08420825
Data &H091208C008D707A9,&H06BE06C806FF082B,&H0911090808C7079B,&H07A606C607130840
Data &H083A090B08AD0780,&H078106C307340714,&H0864090C090608A9,&H0753077D06C7073C
Data &H0749086C09070879,&H0867074806CC0774,&H078B08A208FB0902,&H081D0713073906D4
Data &H07DD08D308B208EF,&H07C507FD070406F3,&H070A080108DF08C1,&H08A3079E06E30731
Data &H0757086108F108E8,&H08450741077506E0,&H07C30786088908E9,&H08D70810071E06F7
Data &H071707FD08CF08B8,&H088B079406EF0703,&H077D087608E108DE,&H080F0728075B06F0
Data &H080807C108A608CD,&H08A507C507070727,&H0762085008D70870,&H08260741070106FA
Data &H07F808BA088F08CB,&H078807D207140727,&H0768084B08CE086D,&H08190741070C07AF
Data &H080C08BA089A07CB,&H077207080779073B,&H089D08B108C5084E,&H0711072E072407D8
Data &H083C08BE0870079C,&H0748071A07B40880,&H08B3088307BC0810,&H0719079D0756081F
Data &H088C08B10825075C,&H0793074E080D08A9,&H08AF082D0768071C,&H074E080708A3088C
Data &H082B076A07200728,&H080D08A1087008AA,&H076407B2072A0756,&H07C3087608A3081E
Data &H07A1072A0766081C,&H088208970807085A,&H072C077F074107DC,&H088407E6083F0789
Data &H07A2075807FE0890,&H08960818076C0732,&H077B082808990866,&H07E8075007450734
Data &H085408980889087E,&H073D076B073C07AC,&H08350895085507AF,&H074B075807E9087A
Data &H088B0818077807CE,&H078C082D088F0868,&H07CE074F078D073F,&H0868081A08880864
Data &H07DE0759075507D7,&H085D0885081E0784,&H07470792082A07CB,&H085607C50825078E
Data &H07EC078F08240883,&H085507C807560767,&H07EC086B087407FF,&H0774075407B80847
Data &H087D082A079C07FB,&H0794082107C0084A,&H07BF082007950752,&H07A1082B087A0847
Data &H07B10759077F0801,&H0871085707DA0839,&H077407EB078E0812,&H07EC084607C60763
Data &H085508020868085E,&H07D2076B077007DE,&H0862085F07F4077E,&H077107DA084F07FA
Data &H07F3078007D5076F,&H085007FB085F085C,&H07D00770077707DF,&H0860085407EA077E
Data &H078107EC08540805,&H07DA077807C3076E,&H085B085408620847,&H0784076C07910800
Data &H0863083307C30771,&H07A9081908600841,&H07A8076E079B076E,&H085F0824085D0817
Data &H07BD077807CA0835,&H084C07F1078D0775,&H07F3084D085207FD,&H077A078A07E80790
Data &H083407CF077E07C5,&H0818085708200859,&H0778079B077807B1,&H0844084F080407A1
Data &H078F07E808410850,&H07CA0782078D0780,&H0853082D0853082A,&H07BF078007C00821
Data &H084007EE07970780,&H08020849084007EF,&H078007A708020848,&H080807AD078107AE
Data &H083B0847083A0848,&H079C0786079907EC,&H084A081707BE0786,&H07DD083008480813
Data &H078C079707E30794,&H081907C4081F07CA,&H082D07D608280847,&H079B0790079707DE
Data &H0845081907C6078D,&H07E0082C08430811,&H078F07A007EA079A,&H080A07BA081407C3
Data &H083507E8082F083F,&H07BB078F07A807F3,&H083807FD07B1078F,&H0802083A08310834
Data &H079307C3079107B6,&H07DB079D07EA07A5,&H083C0814083C0823,&H079B079E07DA0820
Data &H080C07C3079607A7,&H0830083307FC0838,&H07C0080707B107F6,&H07A207EE07AC0798
Data &H08140837081E07DB,&H07A607E208220836,&H07BA079907B4079C,&H082507E907AC07FD
Data &H0819083408080832,&H07B107A207A407D9,&H082E080107C0079D,&H0805082F082407EB
Data &H07A707DB081807C5,&H07BE079F07D207A4,&H081D0827082A07FB,&H07A407CE080B082E
Data &H07C807A307AF07E6,&H082107ED07B507A2,&H0818082D080F082B,&H07BF07F907AE07E0
Data &H07AA07F007B907A3,&H0815082B080F07D7,&H07C107F908240824,&H07AB07AD07DA07A5
Data &H07F207BD080B07D4,&H082807FE0825081F,&H07FD07B307E10815,&H07E807B707A907C7
Data &H0824080207CD07AB,&H080808250816081B,&H07BF07F107AE07D4,&H07B007F207C107AA
Data &H08150823080807D6,&H07D1080308220818,&H07AD07BF07EE07AF,&H07D607B207F307C3
Data &H081507EA08210806,&H081907D508050820,&H07C007AF07C507F3,&H07FD07CF07B107B9
Data &H081F080C07DF081D,&H07FF081C07E1080C,&H07C507B907B307D1,&H081407ED07C307B1
Data &H0816081A07FB07CF,&H07E6080E081C07F3,&H07B807D9080407BF,&H07BE07B507D707B7
Data &H07EE081B080A07E2,&H07D6080008190811,&H07B607CD07F60815,&H07C707B607C607C0
Data &H07F607CE081007EE,&H081707F708140814,&H07B707C907EF0810,&H07CB07B807C407E8
Data &H07F707D107B907C0,&H081507FD07D70813,&H080B081507F0080F,&H07E507BA07C707EA
Data &H07F207CE07BA07C4,&H081007F607D107BB,&H080F081207F90811,&H07F0080D07D007F3
Data &H07CC07C607BC07CE,&H07BC07E807C807BC,&H0812080807EA07CA,&H07FF0811080907EB
Data &H07DD07FE081107DE,&H07C307DD07C007C3,&H07C007F707D607C0,&H080D080D07F607D6
Data &H07F5080D080D07F5,&H07D707F6080D07D5,&H07C307D807C407C2,&H07C307C407DB07C4
Data &H07D7080C07F807D9,&H07F5080B080B07F5,&H07DA07F8080C0809,&H07C607DD07FB07C5
prop:
Data "48,1,48"
Data "00000000000000000000000000000088888"
Data "00000000000000000000000000008AAAEA8"
Data "0000000000000000000000000000AAAAEA8"
Data "0000000000000000000000000008AAAAE88"
Data "0000000000000000000000000008AAAAA88"
Data "0000000000000000000000000008AAAAA8"
Data "000000000000000000000000000AAAAAA8"
Data "00000000000000000000000000AAAAAA88"
Data "00000000000000000000000000AAAAAA88"
Data "0000000000000000000000000AAAAAAA8A8"
Data "0000000000000000000000008AAAAAA888A8"
Data "000000000000000000000008AAAAAAA8888A800088A8"
Data "00000000000000000000000AAAAAAAA8808AA88AAAAA"
Data "00000000000000000000008AAAAAAA88A000AAAAAAA8"
Data "0000000000000000000000AAAAAAAA888A008AAAAAA8"
Data "0000000000000000000008AAAAAAA88008A08A8AAAA8"
Data "000000000000AAA800000AAAAAAAA88000A8AAA8AAA8"
Data "000000000008AAA800008AAAAAAA88000008AAAA8A88"
Data "00000000008AAAA00008AAAAAAA880000008AAAAAA88"
Data "0000000000AAAA80000AAAAAAAA880000088AAAAEA8"
Data "008AAAA800AAAA80008AAAAAAA8888888AABFFBAA8808"
Data "008AAAAA80AAA80008AAAAAAA8828AAAA2AFBAFFA80088"
Data "008AAAAAAAAAA8000AAAAAAA88228AAAA2BFA88FFB0088"
Data "000AAAAAAAAA8888AAAAAAAA822AAAAAA2BFB28BFFA008"
Data "0008AAAAAAAAAAAAAAAAAAA88AA8AA8AA2BFFBABFFF808"
Data "0000AAAAAAAAAAAAAAAAAA8AAAAAAA8AA2AFFFFFFFFA"
Data "00008AAAAAAAAAAAAAAAA8AAAAAA8AABAA2BFFFFFFF8"
Data "00008AAA8AAAAAAAAAAA8AAAFFFFBAFA8A2AFFFFFFB00A"
Data "0008AAAAAAAAAAAAAAA8AAAABFFBBAA88AA2AFFFFF8111A"
Data "000AAAAAAAAA8AAAAA8AAAAAAAAAAA8AAAA22BFFB80111A"
Data "008AAAAAAAAAAAAAA88AA88AAAAAAAAAA888A8AA80088128"
Data "08AAAAAAAAAAAAAA8808A80000088AA88888800000888128"
Data "8AAAAAAAAAAAAAA88A008A000008AAAAAAA88000088881A8"
Data "8AAAA8AAAAAAAA808A808A80000AAAAAAA8808008800088"
Data "08AA888AAAAAA8000AA008A0008AAAAAAA8008808"
Data "008808AAAAAA800008A808A808AAAAAAA88000088"
Data "00008AAAAAA8000000AA008A8AAAAAAA88000088AA"
Data "0008AAAAAA800000008A808A8AAAAAAA8000023113A"
Data "000AAAAA88000000000A8008AAAAAAA8000081191118"
Data "00888888800000000008A888AAAAAA88000081188118"
Data "000000000000000000008AAA8AAAA880000088111108"
Data "000000000000000000008AAA8AAEA8000000008888"
Data "00000000000000000000AAAAAAAA88"
Data "0000000000000000000AAAAAAAA88"
Data "0000000000000000008AAAAAEA88"
Data "000000000000000008AAAAAAA88"
Data "000000000000000008AAAA888"
Data "00000000000000000888888"
peterp:
Data "30,1,64"
Data "00000000000000000000000000000000FBBB00F62FF"
Data "0000000000000000000000000000000000FBBB266223F"
Data "0000000000000000000000000000000000000F222AA8AF"
Data "0000000000000000000000000000000000000F328AAAAB"
Data "0000000000000000000000000000000000000038ABABBF"
Data "000000000000000000FFF0000000000000000038BBF3B00000000000FFFFFFBF"
Data "00000000000000000FBBFFFFF0000000000000BAFFFFF0000000FFFFFFFFFFFF"
Data "000000000000000000FFFFFFFFFFF0000000000BBFFBF00000FFFFFFFF0FFF"
Data "0000000000000000000FF0FFFFFFBFF00000000FAF99F000FFFFFFFF"
Data "000000000000000000000000FBFFFFFFB3FF00FFBFFFFFF73FFFBFF"
Data "00000000000000000000000000FFFFFFFE6677631FFB6666FFBFF"
Data "0000000000000000000000000000FFFFFF66666311F12666EBF"
Data "0000000000000000000000000000000FB366666111B326623F"
Data "000000000000000000000000000000000FFFF322663366FF"
Data "0000000000000000000000000000000000000F6666666B"
Data "0000000000000000000000000000FFF000000F6666666F"
Data "0000000000000000000000000000FFFFFF000F2666666F"
Data "000000000000000000000000000000FFFFFFBF666662F"
Data "0000000000000000000000000000000FFBF313666663F"
Data "00000000000000000000000000000FFFB3311366666F"
Data "000000000000000000000000000F666666612136663F"
Data "00000000000000000000000000F666666666631362F"
Data "0000000000000F0000000000FFEE6666666666111F"
Data "00000000000FFEEEEEFFFFFEEEEE626666666663F"
Data "000000000FEEEEEEEEEEEEEEEEEE66666666666F"
Data "000AA2BFEEEEEEEEEEEEEEEEEEEEE666666667F"
Data "00AAAEEEEEEEEEEE66EEEEEEEEEEE6666666F"
Data "AAAA86EEF00000000FFEEEEEEEEEE66662FF"
Data "AABBFBF0000000000000FFEEEEEEEF337F"
Data "BF0000000000000000000000000000F3F"

oing:
Data &H081707F708170807,&H07F707E708070827,&H0817089808770837,&H0BBB07D706860746
Data &H0191040308170C1B,&H0DCC0BBB08670444,&H040307160B4A0E5D,&H083703C301D10222
Data &H0C0B0E4D0DFD0C0B,&H01B10252048407D7,&H0DDD0BAA085703F3,&H04D408170C6B0E3D
Data &H0756033301B10262,&H0CDC0E4D0DAC0B0A,&H01C102D2058508C8,&H0D2C0A19069602C2
Data &H05F509C90D4C0E3D,&H05D5033302110383,&H0E4D0CEC0A490807,&H0272054409480D5C
Data &H0ABA06B602A201D1,&H08C80D2C0E5D0D2C,&H02E201B102C20544,&H0E4D0D6C0AFA0736
Data &H02A2054408F80D3C,&H0A89067602A201C1,&H09680D7C0E4D0D4C,&H027201B102B20575
Data &H0E5D0D1C0A3905F5,&H034306250A190D9C,&H09B905B5026201B1,&H0A890D8C0E2D0C5B
Data &H02A203F3053406E6,&H0C8B099905950211,&H07460B5A0E1D0DED,&H047401D102320413
Data &H0E1D0DBC0B6A08B8,&H0272046406E60ABA,&H0BFB0938053401F1,&H07560B6A0E3D0DCC
Data &H043301B102B204A4,&H0E4D0D8C0B6A0877,&H029204E407E70C6B,&H0AAA0736030201C1
Data &H09280D3C0E4D0D6C,&H029201D102F20585,&H0D1C0B6A09E90615,&H052408C80D1C0E3D
Data &H05E5029201D10292,&H0D6C0E5D0D1C0A39,&H01A10373061509D9,&H0CCC0A4906B602E2
Data &H05B509180CFC0E4D,&H06A602D201B10322,&H0CDC0E4D0CDC0A19,&H01B1033305C508F8
Data &H0CFC0A6907160363,&H05B508F80CCC0E3D,&H0716036301D10333,&H0C4B0DED0CDC0A69
Data &H0524051405950888,&H09C905E502820383,&H0B5A0E2D0DFD0C7B,&H01E1021103D30726
Data &H0DDD0BBB08670433,&H041306D60AAA0E2D,&H09A9058502110222,&H0AFA0DFD0E1D0C8B
Data &H02010222044406E6,&H0E0D0C1B09580544,&H042306A60A990DCC,&H0928053402320201
Data &H0AAA0DCC0DFD0BDB,&H02D20242047406E6,&H0A990B2A099905D5,&H06E60A990D7C0BFB
Data &H04B401C102B20474,&H0E2D0DBC0B9A08D8,&H02A2050407660B3A,&H0BBB096805B50252
Data &H065509990D1C0DCC,&H0686030202220423,&H0C5B0DBC0C2B09B9,&H02B203E3060508E8
Data &H0CAB0A5907660423,&H05A508570BAA0D6C,&H07F704C402C20383,&H0AFA0D1C0CAB0ACA
Data &H0827043303F30766,&H076603C3048407C7,&H0D0C0E3D0CAB0A79,&H01C102E2058508E8
Data &H0CEC0A2906C602C2,&H053408370C3B0E5D,&H0888047401C102F2,&H0B2A0E1D0DED0B7A
Data &H0211024204A40766,&H0DED0BEB09280575,&H03E306660A090D6C,&H09D90625029201E1
Data &H09380CCC0E4D0C8B,&H038301D1036305C5,&H0B8A0E2D0B6A0766,&H07F70ABA09A90787
Data &H046401D103220514,&H0E3D0DFD0BFB0888,&H0201049407870BAA,&H0C7B097805950232
Data &H05A508F80CEC0E5D,&H07E703B301B102E2,&H0ADA0DFD0DED0B5A,&H033301E1040306E6
Data &H0E3D0CFC0A4906B6,&H02E2051408670BDB,&H0BBB08E8057502A2,&H065509780C3B0D1C
Data &H0C7B05A502520343,&H0333035308880D7C,&H0E0D0D1C0A5907A7,&H01D103F306860A79
Data &H0CCC09F906050252,&H052408A80CAB0E6D,&H08D804B401C10292,&H0A190DBC0E1D0BDB
Data &H02F201B103630666,&H0E1D0D5C0A890706,&H023204B407A70B8A,&H0C4B092805950222
Data &H05B509180CDC0E2D,&H0817047402110322,&H08670D4C0DFD0B9A,&H0A9908E803D30302
Data &H0595056506A60898,&H0BBB0BCB09F907A7,&H0343057507D70A89,&H0BFB0988067603E3
Data &H059507E70A790C3B,&H0928068604640403,&H08270AEA0C1B0B6A,&H070604C4043305C5
Data &H0A190B6A0B1A0968,&H05C504F405C507C7,&H0A790ABA097807B7,&H05A505E507360918
Data &H0C0B091807970655,&H01B1046408D80C4B,&H0E3D0BAA089804C4,&H0252052408370C5B
Data &H0C5B097805D50232,&H04E408370C4B0E7D,&H09E90625028201F1,&H07A70B8A0E5D0CFC
Data &H06B602B201D10433,&H0AFA0E0D0DAC0A89,&H032201B103D30716,&H0D9C0DDD0AEA0756
Data &H02010333066609F9,&H0D9C0BAA08470494,&H02E205D508C80C2B,&H0CEC09A9061502C2
Data &H040306E609E90D2C,&H0B1A088805650312,&H060508A80B9A0CDC,&H093806A603F303B3
Data &H078709F90BCB0B8A,&H080705C504840565,&H08880A690B4A0A09,&H0777059505440686
Data &H08D80A390A790938,&H071605B505E50726,&H09380A590A1908C8,&H06860595063507A7
Data &H09C909E909880847,&H036305E5087709E9,&H0D7C0A7907C70484,&H02B205D508F80C4B
Data &H0D1C09C906E60343,&H02E206B60A090D9C,&H0CBB091805A50211,&H038307360A990DFD
Data &H0C3B0898051401E1,&H045407E70B6A0E0D,&H0BAA0807043301D1,&H049408170BAA0DCC
Data &H0AFA078703C30242,&H053408980BFB0D9C,&H0B1A07C7040302D2,&H09A908E808C80B9A
Data &H04E4035304F407F7,&H0B5A0CCC0B4A0827,&H050403C305240837,&H0ADA0C1B0ACA07F7
Data &H056503D304F40807,&H09C90BAA0B0A0888,&H06A604B404E40726,&H09280AFA0B0A0958
Data &H0726056505550706,&H08980A290ABA0968,&H07E7066605C506C6,&H07B708F809C90968
Data &H08070716069606A6,&H03E309180C3B0A89,&H0E0D0A19057501F1,&H01A104C409480D3C
Data &H0E6D0C7B07E703C3,&H01E102B207660BCB,&H0D8C0E1D0A2904F4,&H03B301A104640978
Data &H0AEA0E1D0D4C0877,&H06E602B201F105C5,&H07060BBB0E4D0C0B,&H0B3A062502520292
Data &H036307970BCB0E0D,&H0D2C0A6905F502B2,&H03C3049408070BEB,&H0C1B095807D705D5
Data &H01C1050409A90D0C,&H0D6C0CCC08170383,&H04B402C2056509D9,&H09080C2B0C7B0908
Data &H0928057503830555,&H04B408270B6A0BFB,&H0BEB09F9067603E3,&H052404A407360A59
Data &H08C80B1A0ACA07E7,&H093806E605650635,&H05E507B709C90A99,&H0A19097807C705F5
Data &H06660655077708E8,&H07770BFB0B2A07A7,&H0D5C080703530242,&H01E103C309880DBC
Data &H0B9A0E7D0AFA05A5,&H08F8040301A105F5,&H02A208170CDC0E0D,&H0DCC0CDC074602B2
Data &H06050232044409A9,&H05E50B1A0DED0B3A,&H0D2C09A904840262,&H0484035306C60B5A
Data &H07360B3A0C2B08E8,&H0B6A087704D40423,&H05B5051407A70AFA,&H0797074609580877
Data &H02C207160B8A0B8A,&H0C1B0CAB08670383,&H0928048403C307A7,&H043306760ADA0C4B
Data &H09280B2A09C90615,&H0978074605650655,&H06F6064507970978,&H06A6089809E90928
Data &H09B9097807A70635,&H07F706C606D60847,&H06E607D709280938,&H08B8091808370716
Data &H07D70756074607B7,&H08F80B9A094807E7,&H0DAC07A702620333,&H0494026207260D2C
Data &H03A30A090E0D0ABA,&H0B8A0D1C084702F2,&H0BDB065502C205A5,&H054403D307A70C8B
Data &H04E409580C7B0A39,&H0A790BCB08A80474,&H0ACA06F604330645,&H062504E407B70B0A
Data &H056508470ABA09C9,&H09380ACA091805F5,&H0A4907F705A50645,&H06550504070609B9
Data &H035308B80CCC0AAA,&H09280CFC09F90413,&H0D0C09D9040303C3,&H0988040304540999
Data &H0514045409480C8B,&H048408670BBB09D9,&H08980B3A09880565,&H09A9090806450595
Data &H0978080706C607C7,&H087706C606C60888,&H0726071608670978,&H070607C708C80888
Data &H074608C808F807C7,&H0ACA0B5A07F70686,&H0DCC079702010484,&H09B9035304440B9A
Data &H048402E209380DED,&H028207560D3C0B4A,&H05650BBB0C9B0645,&H09880C9B09180393
Data &H0B8A0AAA05550474,&H0B6A07F704840716,&H097805B505650948,&H0807064507870A29
Data &H0736068608270978,&H075607D7090808E8,&H07F70827087707F7,&H062506D608370847
Data &H037308C80C7B0968,&H05750ACA0B4A0585,&H07260B1A09F904D4,&H08370A89084704F4
Data &H0867097807E70666,&H081708A8075606F6,&H083708A807C70766,&H0817083707B70787
Data &H07F70877085707D7,&H08370888082707C7,&H0817085707D70797,&H0837081707F707E7
Data &H07E7083707B707C7,&H0B5A09F907970736,&H0E0D07C701A105B5,&H0BCB045403830A09
Data &H0B2A046405140CDC,&H07B7059506350B0A,&H0888066608370999,&H092807F707460938
Data &H085707C707B70888,&H08B80766079708B8,&H07F7079707870877,&H07F707A707E707F7
Data &H07E707F707E70847,&H08070837081707E7,&H0857082708070817,&H06A607A708270867
Data &H059508E80B3A0837,&H0978074607F70827,&H085708E806C607B7,&H087707C708170797
Data &H0837081707E70888,&H07E707E707E70797,&H082707B707E70837,&H0807081708370837
Data &H0857080707F70807,&H0827081708270857,&H081707B707B70807,&H07F7080708370857
Data &H0817080707D707D7,&H0A190807078707D7,&H0BDB060503930938,&H057509A908880686
Data &H08470716089809B9,&H06D607A709580787,&H07970898084707E7,&H088807F7080707E7
Data &H0827089808170847,&H083707F707C707A7,&H07C707C707C70817,&H07D7082707E707A7
Data &H07D707F7081707E7,&H0817085708470807,&H08370807083707E7,&H06C6072608470837
Data &H083706B60A3909C9,&H079708D807360736,&H080708C807C707F7,&H08670888082707B7
Data &H07F7082707E70807,&H081707E707D70807,&H0817079707A70817,&H07D7083708570857
Data &H0857082707E707F7,&H07E707F708470867,&H0827080707F707E7,&H0847083707F70807
Data &H07B707A707B70817,&H0A490918080707D7,&H07C7098804330605,&H07A70777083709B9
Data &H082707A7085708B8,&H06C606F6081708E8,&H07F7082708880817,&H08880898085707D7
Data &H07D707F707E707F7,&H07F7081707C707C7,&H07B707B707B707A7,&H08470827080707D7
Data &H07D7081708570877,&H0837081707E707A7,&H08170827085707F7,&H0918085707B70766
Data &H080707C707870837,&H080707D707F70857,&H07D707D708370888,&H07F7084708880867
Data &H07A707D708070817,&H07F707F707C707D7,&H0827080707C707F7,&H07D7082708980867
Data &H0857080707C707B7,&H0807083708770867,&H07C707D707D707E7,&H0847084708170807
Data &H080707B707A707E7,&H0756082708470827,&H0847085707F70797,&H0807080707E70807
Data &H0000081707E707F7,&H01A101A101A101A1,&H01A101A101A101A1,&H01A101A101A101A1
Data &H01A101A101A101A1,&H0000000000000000,&H0000000000000000,&H0000000000000000
karateka:
Data "64,1,64"
Data "0000000000002EEEEEEA"
Data "00000000000AAEEEEAAAA"
Data "0000000000AAEEAAAAAAA"
Data "000000000AAAAA8888888"
Data "0000000AAAAAAAA888888"
Data "000000AFAAEEAAAAAAF11"
Data "00000AFFAAAAAAAF3BF12"
Data "00002A0AAEAAAAAFFFFFA"
Data "000000AAAEEAAAEFFFFBA"
Data "0000000AAEAAABFFFf88"
Data "00000000AAAAABBFFFAA0000000000000000000000000000000002AAA"
Data "000000000AAAAFAAFFFA00000000000000000000000000002AAAAFAFA2"
Data "00000000002AFFAAFBAA000000000000000000000002AAAAFFFFFFAFA"
Data "000000000002FFFFFF2000000000000000000002AAAFFFFFFAAAAAAAA"
Data "00000000002ABBFFFFA0000000000002AAAAAAAFFFFFFFFAA"
Data "00AAFA3AAAAFFAFFFFAA32AAAAAAAAAFFFFFFFFFFFFFFAA"
Data "02AFFFBBFFFFFFFFFFFB1FFFFFFFFFFFFFFFFFFFFFFAA"
Data "0AFFFFF1BFAFFFBAFFF1BFFFFFFFFFFFFFFFFFFAAAA"
Data "02AFFFFB1FFFFFFFFFB1FFFFFFFFFFAAAAAAAAA2000000000000000000AAA"
Data "00AABFFFFFFFFFFFFF11FFFFAAAAABFAAAAA2000000000000000000000ABAA"
Data "00AAAFFFFFFFFFFFFB11BFFAAAAFFFFA00000000000000000000000000ABFA"
Data "00AAAAFFFFFFFFFFFFFFFFFFFFFFFFAA000000000000000000000000000FFFA"
Data "000AAAAFFFFFFFAAFFFFFFFFFFFFFFAA000000000000000000000000000FFFA"
Data "000AAFAAAAAFFFFFFFFFFAAAAAAAAAA0000000000000000000000000002FFFA"
Data "0000AFF11AAAFFFFFFFB11BAAA00000000000000000003311130000000AFFF2"
Data "0000AAB1111BBBBBB311111AAA00000000000333333311111333300002AFFFA"
Data "00000A111111111111111111A2000000002333111111111113BBFAAAAAFFFFA"
Data "0000011111111111111111111300000001111111111111111AFFFFFFFFFFFFA2"
Data "0000031111111111111111111300000311111111111111111AFFFFFFFFFFFFFF"
Data "0000003111111111111111111100001111111111111111111AFFFFFAAAAAAFBA"
Data "0000003111111111111111111300011111111111111111111AAAAA200000022"
Data "0000000111111111111111111100311111111111111111111373"
Data "000000031111111111111111180311111111111111111111113"
Data "000000001111111111111111183111111111111113333330333"
Data "0000000011111113331111188811111111111113"
Data "0000000021111111133188888111111111111111"
Data "000000000311111111881811111111111111111"
Data "00000000001111118881111111111111111113"
Data "0000000000311188881111111111111111111"
Data "0000000000038881111111111111111111113"
Data "000000000A88881111111111111111111113"
Data "000000A888883111111111111111111111"
Data "000000288A20311111111111111111111"
Data "000000000000313111111111111111113"
Data "00000000000031111111111111111113"
Data "0000000000003111111111111111113"
Data "00000000000111111111111111113"
Data "000000000311111111111111113"
Data "00000000311111111131111112"
Data "000000031111111111111111"
Data "00000031111111111111111"
Data "0000031111111111111113"
Data "000031111111111111112"
Data "000311111111111111"
Data "0031111111111111100032"
Data "0211111111111113333731333"
Data "0111111111111771311111111300AAA"
Data "31111111113137711311111113AAAFFA"
Data "1111111111113331111111111BFFFFFA"
Data "111111111111711111111111BFFFFFFAA2"
Data "111111111111311133131113AAAAFFFFFFA2"
Data "1111111111111133330000000002AAFFFFFAA"
Data "031113331331300000000000000000AAAAABAA2"
Data "0000000000000000000000000000000000FAB2"
elephant:
Data "64,1,64"
Data "00000000000000000000000000000000000000000000000BBBB"
Data "00000000000000000000000000000000000000000000000AFFB"
Data "000000000000000000000000000000000000000000000002AA2"
Data "00000000000000000000000000000000000000000000000A8A"
Data "00000000000000000000000000000000000000000000000A88"
Data "00000000000000000000000000000000000000000000002888"
Data "0000000000000000000000000000000000000000000000B88A"
Data "000000000000000000000000000000000000000000000B888A"
Data "00000000000000000000000000000022000000000000BB888A"
Data "00000000000000000000000000022B32020000000000B8888A"
Data "0000000000000000000000000022B3B2B20000000000B8888A"
Data "000000000000000000000000022BBBBBBB2002000022288A8A"
Data "00000000000000000000000022BBBBBBBBB2320000BFFFBB82"
Data "000000000000000000000203BBBBBBBBBBBB33B2002FFFFFFF"
Data "0000000000000000000002B3BBBBBBBBBBBBB332202BFBFBFF2"
Data "0000000000000000020BBBB2BBBBBBB2BBBBBB3B2B2B3BBBBF2"
Data "000000000000000002B2BBBBBBBBBBB3B2BBBBBBB22BBBB222"
Data "00000000000000002BBBBBBBBBBBBB23222BBBBBB22BBBBB22"
Data "00000000000000022BBBBBBBBBBBB222B222B2BBB2BBBBBBB200000022"
Data "0000000000000B2BBBBBBBBBBBB32B3FAB23223B22BBBBBBA300000B02"
Data "00000000000022BBBBBBBBBBBBB22BBBABBBB22222BBBBB22222B22222B"
Data "00000000000B2BBBBBBBBBBBBB22BBBABBBBBA2BBBBBBB223222B22BBB2"
Data "000000000002BBBBBBBBBBBB223BBBAABBBBBBB223BBBB22B232B2BBBB22"
Data "00000000002BBBBBBBBBBBBB2BBBBBA2BBBBBAB3B3BBBBB2A2B2BBBBBBBB2B"
Data "00000000002BBBBBBBBBBBB22BBBBBAABBBBABABBBBBB000A010BBBBBBBBB222"
Data "000000000B2BBBBBBBBBBBBB2BBBBBBBBBAAAFBBBBBBB111BB112BBBBBBBBB22"
Data "0020000002BBBBBBBBBBBBBB2BBBBBBBBBBBABBBBBBB31123B102BBBBBBBBB2"
Data "0002000002BBBBBBBBBBBBBB22BBBBBBBBBFABBBB3BB2FFFBBFF22BBBBBBB32"
Data "02120000B2BBBBBBBBBBBBBB22BBBBBBBBBBBBBB22BB3223BBBB32BBBBBBB32"
Data "0012000023BBBBBBBBBBBBBB22BBBBBBBBBBBBBB23BBB33BBBB3B3BBBBBBB32"
Data "20120000B3BBBBBBBBBBBBBBB2BBBBBBBBBBBBB02BBBBBBB3BB233BBBBBBB32"
Data "0122000023BBBBBBBBBBBBBBB2BBBBBBBBBBBBB2BBBBBBBBBBB323BBBBBBB2"
Data "011200002BBBBBBBBBBBBBBBB2BBBBBBBBBBBB22BBBBBBBBBBBB22BBBBBBBB"
Data "010200002BBBBBBBBBBBBBBBB22BBBBBBBBBBB22BBBBBBBBBBBB22BB33BB3B"
Data "1100000023BBBBBBBBBBBBBBBB2BBBBBBBBBBB22BBBBBBBBBBBB2222222222"
Data "0020000023BBBBBBBBBBBBBBBB2BBBBBBBBBBB2BBBBB22BBBBBB222000022"
Data "00200000B2BBBBBBBBBBBBBBBBB2222BBBBBBB222BB222BBBBBB22"
Data "0220000002BBBBBBBBBBBB3BBBBB33222BBBBB222B22B22BBBBBBA"
Data "02200000023BBBBBBBBBB223BBBBB3B2222232222222222BBBBBB2"
Data "00220000022BBBBBBBBB33233BBBBBB33222223BB222222BBBB33A"
Data "000200202222BBBBBBBB33B23BBBBBBBB2B232BB3222222BBB3222"
Data "00002B2B2B222BBBBBBB3BBBBBBBBBBBBBBBBBBB2BBB322BBB3B3A"
Data "000000000000B2BBBBBB3BBBBBBBBBBBBBBBBBB32BBBB222BBBBB2"
Data "000000000000022BBBBB3BBBBBBBBBBBBBBBBBB32BBBB222BBBBB2"
Data "0000000000000222BBBB3BBBBBBBBBBBBBBBBBB32BBBB222BBBBB22"
Data "0000000000000B222BBB3BBBBBBBBBBBBBBBBBB32BBB322B2BBBB2"
Data "00000000000000222222B3BBBBBBBBBBB3BBBBB32BB332202BBBB2"
Data "0000000000000022222223BBBBBBBBBBB3BBBBB22BB322202BBBB2"
Data "00000000000000B2B23222BBBBBBBBBBB2BBBBB223B3B2B02BBBB2"
Data "0000000000000002BB33223BBBBBBBBB232BBB222BBBB3202BBBB2"
Data "0000000000000002BBB3223BBBBBB2BB22222222BBB2B3B023BBB2"
Data "00000000000000023BBB232BBBBB222B2222222BBB32332023BB22"
Data "000000000000000023B3B32BBBBB22BB22222222BBB2320023BB32"
Data "000000000000000023B3332BBBBBBBBB22222222BBBB22002BBB22"
Data "0000000000000000B3BB2232BBBBB22332222230BBBB20002BBBB2"
Data "000000000000000023BBBBB22BBBBB2BB22223232BBB20002BBB22"
Data "000000000000000022BBBBB32BBBBBBBB222232322B320022BBB2"
Data "000000000000000022BBBBBB2BBBBBBBBB222322BA232002BBB22"
Data "000000000000000002B333222BBBBBBBBB2222222B322222B32"
Data "000000000000000002B3AA222BBBBBBBBB32222FA2BB3BB3322"
Data "00000000000000000B2B22A22BBB32222B22002F2A22BBB222"
Data "000000000000000000BF2FF222B3AAB2222000000B222B2B"
Data "0000000000000000000000000222F2FBBA"
Data "000000000000000000000000000FF2F2B"
Data 11,128,128,128

dots:
Data "48,1,48"
Data ""
Data ""
Data "00000000000000000000000009"
Data "000000000000000000000000999"
Data "00000000000000000000000099"
Data "0000000000000011000000000000000088"
Data "0000000000000011"
Data "0000008"
Data "00000880000000000000000000000000000000000E"
Data "0000088000000000000000000000000E000000000E"
Data "000000000000000000006200000000EEE"
Data "0000000000000000000666"
Data "0000000660000000000062"
Data "0000000660000000000000000077"
Data "0000000000000000000000000077"
Data "0000000000000099000000000077"
Data "00000000000000990000000000000000000000006"
Data "000000000000000000000000000000000000000666"
Data "000000000000000000000080000000990000000062"
Data "000000000000000000000888000000999"
Data "000EE000000000000000008800000099"
Data "000EE0000111"
Data "00000000011"
Data ""
Data "00000000000000077"
Data "00000000000000077000000099"
Data "0000000000000000000000000900000000110000000077"
Data "0000070000000000000000000000000000110000000077"
Data "000077"
Data "000037"
Data ""
Data "0000000000009"
Data "0000000000000000000000000000000000000088"
Data "00000000000000000000000E"
Data "0000000000000000000000EEE00000077"
Data "00000000000000000000000E0000000777"
Data "000000000088000000000000000000007"
Data ""
Data ""
Data "00000000000000000000000000000000000008"
Data "00000000000000000000000000000000000088"
Data "00000000000000000000000077000000000088"
Data "00000000000099"
Data "00000000000099"
Data ""
Data "00000000000000000000000000EE"
Data "00000000000000000000000000EE"
Data ""


'Ode sound factors
ode:
Data 0.7491,0.7491,0.8408,0.8908
Data 0.8908,0.8408,0.7491,0.6674
Data 0.5946,0.5946,0.6674,0.7491
Data 0.7491,0.6674,0.6674,0
odem: 'Merrily We Roll Along
Data 0.7492,0.6674,0.5946,0.6674'E4 D4 C4 D4
Data 0.7492,0.7492,0.7492       'E4 E4 E4
Data 0.6674,0.6674,0.6674       'D4 D4 D4
Data 0.7492,0.8909,0.8909       'E4 G4 G4
Data 0.7492,0.6674,0.5946,0.6674'E4 D4 C4 D4
Data 0.7492,0.7492,0.7492       'E4 E4 E4
Data 0.6674,0.6674,0.7492,0.6674'D4 D4 E4 D4
Data 0.5946,0                   'C4,0
london:
Data 0.8909,1.0000,0.8909,0.7937,0.7492,0.7937
Data 0.8909,0.8909,0.7492,0.8909,1.0000,0.8909
Data 0.7937,0.7492
Data 0.8909,1.0000,0.8909,0.7937,0.7492,0.7937
Data 0.8909,0.8909,0.7492,0.8909,1.0000,0.8909
Data 0.7937,0.7492,0                             